#pragma once

#include <boost/assign.hpp>

#include <pgg/enumeration.h>
#include <mail/ymod_queuedb/include/types.h>

namespace ymod_queuedb::pg {

struct TaskStateImpl {
    using Enum = ymod_queuedb::TaskState;
    using Filler = TaskStateImpl;
    using Map = pgg::Enum2String<Enum>::Map;

    // clang-format off
    void fill(Map& map) {
        boost::assign::insert(map)
            ( Enum::pending,    "pending" )
            ( Enum::inProgress, "in_progress" )
            ( Enum::complete,   "complete" )
            ( Enum::error,      "error" );
    }
    // clang-format on
};

using TaskState = pgg::Enumeration<TaskStateImpl, TaskStateImpl::Enum::pending>;

}  // namespace ymod_queuedb::pg
