#pragma once

#include <mail/ymod_queuedb/include/types.h>
#include <logdog/format/tskv.h>
#include <mail/ymod_queuedb/include/reflection.h>

namespace ymod_queuedb {

struct StrippedTask {
    const Task& t;

    StrippedTask(const Task& task)
        : t(task)
    { }
};

namespace attr {
LOGDOG_DEFINE_ATTRIBUTE(TaskType, task_type)
LOGDOG_DEFINE_ATTRIBUTE(TaskId, task_id)
LOGDOG_DEFINE_ATTRIBUTE(Task, task)
namespace stripped {
LOGDOG_DEFINE_ATTRIBUTE(StrippedTask, task)
}
}

using namespace attr;

}

namespace logdog::tskv {

template <>
struct to_tskv_impl<ymod_queuedb::TaskType> {
    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_queuedb::TaskType& type) {
        out << ytskv::attr(std::string(key), type.t);
    }
};

template <>
struct to_tskv_impl<ymod_queuedb::TaskId> {
    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_queuedb::TaskId& id) {
        out << ytskv::attr(std::string(key), id.t);
    }
};

template <>
struct to_tskv_impl<ymod_queuedb::StrippedTask> {
    template<class T>
    static const std::string& to_string(const T& v) {
        return static_cast<const std::string&>(v);
    }

    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_queuedb::StrippedTask& task) {
        const std::string name = key;

        out << ytskv::attr(name + ".id", task.t.taskId)
            << ytskv::attr(name + ".uid", task.t.uid)
            << ytskv::attr(name + ".created", task.t.created)
            << ytskv::attr(name + ".type", to_string(task.t.task))
        ;
    }
};

template <>
struct to_tskv_impl<ymod_queuedb::Task> {
    template<class T>
    static const std::string& to_string(const T& v) {
        return static_cast<const std::string&>(v);
    }

    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_queuedb::Task& task) {
        const std::string name = key;

        out << ytskv::attr(name + ".id", task.taskId)
            << ytskv::attr(name + ".uid", task.uid)
            << ytskv::attr(name + ".type", to_string(task.task))
            << ytskv::attr(name + ".worker", to_string(task.worker))
            << ytskv::attr(name + ".requestId", to_string(task.requestId))
            << ytskv::attr(name + ".timeoutSec", static_cast<std::chrono::seconds>(task.timeoutSec))
            << ytskv::attr(name + ".state", yamail::data::reflection::to_string(task.state))
            << ytskv::attr(name + ".service", task.service)
            << ytskv::attr(name + ".args", task.taskArgs)
            << ytskv::attr(name + ".reassignmentCount", task.reassignmentCount)
            << ytskv::attr(name + ".tries", task.tries)
            << ytskv::attr(name + ".created", task.created)
            << ytskv::attr(name + ".processingDate", task.processingDate)
        ;

        for (std::size_t i = 0; i < task.tryNotices.size(); i++) {
            out << ytskv::attr(name + ".tryNotices." + std::to_string(i), task.tryNotices[i]);
        }
    }
};

}
