#pragma once

#include <io_result/io_result.h>
#include <mail_errors/error_code.h>
#include <boost/serialization/strong_typedef.hpp>

namespace ymod_queuedb {

BOOST_STRONG_TYPEDEF(std::int64_t, Uid)
BOOST_STRONG_TYPEDEF(std::int64_t, TaskId)
BOOST_STRONG_TYPEDEF(std::string, TaskType)
BOOST_STRONG_TYPEDEF(std::optional<std::string>, TaskArgs)
BOOST_STRONG_TYPEDEF(std::string, Worker)
BOOST_STRONG_TYPEDEF(std::string, Reason)
BOOST_STRONG_TYPEDEF(std::int32_t, TasksLimit)
BOOST_STRONG_TYPEDEF(std::int32_t, MaxRetries)
BOOST_STRONG_TYPEDEF(std::chrono::seconds, Delay)
BOOST_STRONG_TYPEDEF(std::chrono::seconds, Timeout)
BOOST_STRONG_TYPEDEF(std::string, RequestId)

// clang-format off
enum class TaskState {
    pending,
    inProgress,
    complete,
    error
};
// clang-format on

struct Task {
    TaskId taskId;
    Uid uid;
    TaskType task;
    Worker worker;
    Timeout timeoutSec;
    TaskState state;
    RequestId requestId;
    std::string service;
    std::string taskArgs;
    std::uint32_t reassignmentCount;
    std::uint32_t tries;
    std::vector<std::string> tryNotices;
    std::time_t created;
    std::time_t processingDate;

    bool operator== (const Task& that) const noexcept {
        return taskId == that.taskId
            && uid == that.uid
            && service == that.service
            && task == that.task
            && state == that.state
            && taskArgs == that.taskArgs
            && reassignmentCount == that.reassignmentCount
            && tries == that.tries
            && tryNotices == that.tryNotices
            && created == that.created
            && processingDate == that.processingDate
            && timeoutSec == that.timeoutSec
            && worker == that.worker
            && requestId == that.requestId;
    }
};

using TaskList = std::vector<Task>;

using OnExecute = io_result::Hook<>;
using OnAcquireTasks = io_result::Hook<TaskList>;
using OnAddTask = io_result::Hook<TaskId>;

}
