#include <mail/ymod_queuedb/include/error.h>

namespace ymod_queuedb {

const QueueCategory& getQueueCategory() {
    static QueueCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(QueueResult e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getQueueCategory());
}

mail_errors::error_code make_error(QueueResult e, const std::string& what) {
    return mail_errors::error_code(e, what);
}

}
