#include <mail/ymod_queuedb_worker/include/internal/error.h>

namespace ymod_queuedb {

std::string WorkerCategory::message(int v) const {
    switch(WorkerError(v)) {
        case WorkerError::unknownTaskType:
            return "unknown task type";
        case WorkerError::unexpectedException:
            return "unexpected exception";
    }
    return "unknown enum code";
}

const WorkerCategory& getWorkerCategory() {
    static WorkerCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(WorkerError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getWorkerCategory());
}

mail_errors::error_code make_error(WorkerError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
