#include <mail/ymod_queuedb_worker/include/exec_or_wait.h>
#include <mail/ymod_queuedb_worker/include/internal/as_seconds.h>
#include <mail/ymod_queuedb_worker/include/internal/timer.h>
#include <boost/asio/steady_timer.hpp>

namespace ymod_queuedb {

ExecOrWaitFactory::ExecOrWaitFactory(unsigned tries,
                                     std::chrono::seconds sleep,
                                     std::shared_ptr<yplatform::reactor> reactor)
    : tries(tries)
    , sleep(sleep)
    , reactor(std::move(reactor))
{ }

ExecOrWaitFactory::ExecOrWaitFactory(const yplatform::ptree& cfg,
                                     std::shared_ptr<yplatform::reactor> reactor)
    : tries(cfg.get<unsigned>("tries"))
    , sleep(asSeconds(cfg, "sleep_dur"))
    , reactor(std::move(reactor))
{ }

ExecOrWait ExecOrWaitFactory::product(boost::asio::yield_context yield, yplatform::task_context_ptr ctx) const {
    return [=, tries=this->tries, reactor=this->reactor, sleep=this->sleep] (std::function<bool()> fn) {
        int64_t i = tries;
        while (i-- > 0 && !ctx->is_cancelled()) {
            if (fn()) {
                break;
            } else {
                auto yy = io_result::make_yield_context(yield);
                Timer(reactor).asyncWait(sleep, yy);
            }
        }
    };
}

}
