#pragma once

#include <yplatform/reactor.h>
#include <io_result/io_result.h>


namespace ymod_queuedb {

using ExecOrWait = std::function<void(std::function<bool()>)>;

struct ExecOrWaitFactory {
    unsigned tries;
    std::chrono::seconds sleep;
    std::shared_ptr<yplatform::reactor> reactor;

    ExecOrWaitFactory(unsigned tries,
                      std::chrono::seconds sleep,
                      std::shared_ptr<yplatform::reactor> reactor);

    ExecOrWaitFactory(const yplatform::ptree& cfg, std::shared_ptr<yplatform::reactor> reactor);

    ExecOrWait product(boost::asio::yield_context yield, yplatform::task_context_ptr ctx) const;
};

}
