#pragma once

#include <mail_errors/error_code.h>

namespace ymod_queuedb {

enum class WorkerError {
    unexpectedException = 1,
    unknownTaskType
};

struct WorkerCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "worker";
    }

    std::string message(int v) const override;
};
const WorkerCategory& getWorkerCategory();
mail_errors::error_code::base_type make_error_code(WorkerError e);
mail_errors::error_code make_error(WorkerError e, std::string what);

}

namespace boost::system {
template <>
struct is_error_code_enum<ymod_queuedb::WorkerError> : std::true_type {};
}
