#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/ymod_queuedb/include/types.h>
#include <mail/ymod_queuedb/include/logdog.h>


namespace ymod_queuedb {
namespace log {
using namespace ::logdog::attr;
using namespace attr;
}

inline auto getLogger(const std::string& name) {
    constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-ymod_queuedb-tskv-log"));

    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, name)
    );
}

using Logger = decltype(getLogger(""));

inline auto getWorkerAccessLogger(const std::string& name) {
    static constexpr auto workerAccess = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-ymod_queuedb_access-tskv-log"));

    return ::logdog::make_log(
        workerAccess,
        std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, name)
    );
}

using WorkerAccessLogger = decltype(getWorkerAccessLogger(""));

void accessLogSuccess(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                      const Task& task);

void accessLogDelayed(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                      const Task& task);

void accessLogFail(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                   const std::optional<Task>& task);

}
