#pragma once

#include <mail/ymod_queuedb_worker/include/internal/log.h>
#include <mail/ymod_queuedb_worker/include/task_handler.h>
#include <mail/ymod_queuedb_worker/include/internal/task_context_holder.h>
#include <mail/ymod_queuedb/include/queue.h>
#include <yplatform/reactor.h>
#include <yamail/expected.h>


namespace ymod_queuedb {

struct TaskHandlerInfo {
    MaxRetries maxRetries;
    Delay onFail;
    Delay onDelay;
    TaskHandler handler;
};

using TaskHandlersMap = std::map<TaskType, TaskHandlerInfo>;

TaskHandler trycatch(TaskHandler fn);
TaskHandler trycatchWithLog(Logger logger, TaskHandler fn);

class Loop {
protected:
    TaskHandlersMap taskHandlers;
    std::shared_ptr<yplatform::reactor> reactor;
    QueuePtr queuedb;
    std::chrono::milliseconds sleepTimeout;
    WorkerAccessLogger accessLog;
    TaskContextHolder running;
    Logger logger;
    Worker worker;

    std::function<void(boost::asio::yield_context)> createRefreshTaskCoro(std::weak_ptr<TaskId> weakTaskId,
                                                                          const TaskContextHolder& taskContextHolder,
                                                                          Timeout timeout, const std::string& requestId) const;

    void runRefreshTaskCoro(std::weak_ptr<TaskId> weakTaskId, const TaskContextHolder& taskContextHolder,
                            Timeout timeout, const std::string& requestId) const;

    std::optional<Task> acquireTasks(const TaskContextHolder& taskContextHolder,
                                     boost::asio::yield_context yield) const;

    void processTask(const Task& task, const TaskHandlerInfo& handler,
                     const TaskContextHolder& taskContextHolder,
                     boost::asio::yield_context yield) const;

    void completeTask(const Task& task, const TaskContextHolder& taskContextHolder,
                      boost::asio::yield_context yield) const;
    void delayTask(const Task& task, const TaskContextHolder& taskContextHolder,
                   Delay delay, boost::asio::yield_context yield) const;
    void failTask(const Task& task, const TaskContextHolder& taskContextHolder,
                  MaxRetries maxRetries, Delay delay, const mail_errors::error_code& ec,
                  boost::asio::yield_context yield) const;
    void failTask(const Task& task, const TaskContextHolder& taskContextHolder,
                  MaxRetries maxRetries, Delay delay, const mail_errors::error_code& ec,
                  boost::asio::yield_context yield, const std::nothrow_t &) const;

public:

    static const inline MaxRetries MAX_TRIES_FOR_ERROR = MaxRetries(0);
    static const inline Delay DELAY_FOR_ERROR = Delay(std::chrono::seconds(1));

    Loop(TaskHandlersMap taskHandlers, std::shared_ptr<yplatform::reactor> reactor,
         QueuePtr queuedb, std::chrono::milliseconds sleepTimeout, WorkerAccessLogger accessLog,
         const TaskContextHolder& running, Logger logger, Worker worker);

    void run(boost::asio::yield_context yield) const;
};

}
