#pragma once

#include <boost/asio/steady_timer.hpp>
#include <yplatform/reactor.h>
#include <mail/ymod_queuedb/include/queue.h>
#include <io_result/io_result.h>

namespace ymod_queuedb {

struct Timer {
    std::shared_ptr<boost::asio::steady_timer> timer;

    Timer(std::shared_ptr<yplatform::reactor> reactor)
        : timer(std::make_shared<boost::asio::steady_timer>(*reactor->io()))
    { }

    template <typename Timeout, typename Handler = io_result::sync_context>
    auto asyncWait(Timeout timeout, Handler handler = io_result::use_sync) const {
        using OnTick = io_result::hooks::Hook<>;
        io_result::detail::init_async_result<Handler, OnTick> init(handler);

        timer->expires_after(timeout);
        timer->async_wait(init.handler);

        return init.result.get();
    }

    void cancel() const {
        timer->cancel();
    }
};

}
