#pragma once

#include <mail/ymod_queuedb/include/types.h>
#include <mail/ymod_queuedb_worker/include/task_handler.h>

namespace ymod_queuedb {

struct WorkerModule {
    virtual void addHandler(TaskType type, Delay onFail,
                            MaxRetries tries, Delay onDelay,
                            TaskHandler handler) = 0;
};

void addHandler(const yplatform::ptree& cfg,
                const TaskType& type,
                WorkerModule& worker,
                TaskHandler handler);

}
