#pragma once

#include <yamail/expected.h>
#include <yplatform/task_context.h>

namespace ymod_queuedb {

enum class TaskControl {
    delay = 1,
    permanentFail
};

struct TaskControlCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "task_control";
    }

    std::string message(int v) const override;
};
const TaskControlCategory& getTaskControlCategory();
mail_errors::error_code::base_type make_error_code(TaskControl e);
mail_errors::error_code make_error(TaskControl e);
inline auto make_unexpected(TaskControl e) {
    return yamail::make_unexpected(make_error(e));
}

struct TaskControlDelayException: public std::exception {
    using std::exception::exception;
};

inline void delayOnCancelledTask(const yplatform::task_context_ptr& ctx) {
    if (ctx->is_cancelled()) {
        throw ymod_queuedb::TaskControlDelayException();
    }
}

}

namespace boost::system {
template <>
struct is_error_code_enum<ymod_queuedb::TaskControl> : std::true_type {};
}
