#include <mail/ymod_queuedb_worker/include/task_control.h>

namespace ymod_queuedb {

std::string TaskControlCategory::message(int v) const {
    switch(TaskControl(v)) {
        case TaskControl::delay:
            return "skip task";
        case TaskControl::permanentFail:
            return "permanent fail";
    }
    return "unknown enum code";
}

const TaskControlCategory& getTaskControlCategory() {
    static TaskControlCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(TaskControl e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getTaskControlCategory());
}

mail_errors::error_code make_error(TaskControl e) {
    return mail_errors::error_code(e);
}

}
