from cpython cimport *
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *


cdef class WorkerMetric:
    def __cinit__(self):
        self.__impl.reset(new WorkerTaskStat())


cdef class WorkerMetricsLog:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[WorkerMeters] cm
        for m in cppMeters:
            if isinstance(m, WorkerMetric):
                cm.push_back(WorkerMeters((<WorkerMetric>m).__impl))
            else:
                raise AttributeError("Unknown meter type for ymod_queuedb_worker")
        self.__impl.reset(new WorkerLog(pm, cm, False, <const char*>path))