#include <mail/ymod_queuedb_worker/include/internal/log.h>


namespace ymod_queuedb {
namespace log {
LOGDOG_DEFINE_ATTRIBUTE(std::string, status)
LOGDOG_DEFINE_ATTRIBUTE(double, duration)
}

void accessLogImpl(const WorkerAccessLogger& accessLog,
                   const std::string& status,
                   const yplatform::task_context& ctx,
                   const Task* task) {
    const double duration = (
        boost::posix_time::microsec_clock::local_time() - ctx.begin_time()
    ).total_milliseconds() / 1000.;

    if (task) {
        LOGDOG_(accessLog, notice,
                log::request_id=task->requestId,
                log::status=status,
                log::duration=duration,
                log::stripped::task=StrippedTask(*task));
    } else {
        LOGDOG_(accessLog, notice,
                log::request_id=ctx.uniq_id(),
                log::status=status,
                log::duration=duration);
    }
}

void accessLogSuccess(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                      const Task& task) {
    accessLogImpl(accessLog, "success", ctx, &task);
}

void accessLogDelayed(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                      const Task& task) {
    accessLogImpl(accessLog, "delayed", ctx, &task);
}

void accessLogFail(const WorkerAccessLogger& accessLog, const yplatform::task_context& ctx,
                   const std::optional<Task>& task) {
    accessLogImpl(accessLog, "failed", ctx, task ? &(*task) : nullptr);
}

}
