#pragma once

#include <boost/system/error_code.hpp>

#include <string>
#include <vector>

namespace ymod_ratecontroller {

using error_code = boost::system::error_code;

enum class error : int
{
    ok = 0,
    capacity_exceeded,
    add_to_rc_queue_exception,
    task_aborted,

    COUNT
    // DO NOT FORGET TO EXTEND error_names
};

inline const std::string& error_message(error err)
{
    static constexpr std::initializer_list<const char*> names = {
        "success",
        "queue capacity exceeded",
        "add to rate controller queue exception",
        "task aborted"
    };
    static_assert(
        names.size() == static_cast<size_t>(error::COUNT),
        "Error codes count doesn't correspond with error names count");
    static const std::vector<std::string> error_names(names.begin(), names.end());

    return error_names[static_cast<int>(err)];
}

}

namespace boost { namespace system {

template <>
struct is_error_code_enum<ymod_ratecontroller::error>
{
    static const bool value = true;
};

}}

namespace ymod_ratecontroller {

const boost::system::error_category& get_error_category();

inline error_code make_error_code(error e)
{
    return error_code(static_cast<int>(e), get_error_category());
}

}
