#include <ymod_ratecontroller/errors.h>

namespace ymod_ratecontroller {

struct error_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "ymod_ratecontroller::error_category";
    }

    std::string message(int v) const override
    {
        return error_message(static_cast<error>(v));
    }
};

const boost::system::error_category& get_error_category()
{
    static error_category instance;
    return instance;
}

}
