#include "client_helper.h"
#include "client_helper_impl.h"

#include <yplatform/module_registration.h>

namespace NYmodRateSrv {

TClientHelper::TClientHelper()
    : Impl(std::make_unique<TClientHelperImpl>())
{}

TClientHelper::~TClientHelper() = default;

void TClientHelper::init(const yplatform::ptree& configuration) {
    Impl->Init(configuration);
}

TLimitPtr TClientHelper::GetLimit(const std::string& limit) {
    return Impl->GetLimit(limit);
}

bool TClientHelper::AddKeyToRequestImpl(
    TRequest& request,
    const TLimit& limit,
    std::string id,
    ui64 value,
    TKey key)
{
    return Impl->AddKeyToRequest(request, limit, std::move(id), value, std::move(key));
}

} // namespace NYmodRateSrv

REGISTER_MODULE(NYmodRateSrv::TClientHelper)
