#pragma once

#include "limit.h"
#include "common.h"

#include <mail/ymod_ratesrv/src/request.h>

#include <yplatform/module.h>
#include <yplatform/ptree.h>

#include <memory>
#include <string>

namespace NYmodRateSrv {

class TClientHelperImpl;

class TClientHelper : public yplatform::module {
public:
    TClientHelper();
    ~TClientHelper() override;

    void init(const yplatform::ptree& configuration);

    TLimitPtr GetLimit(const std::string& limit);

    template <typename... TArgs>
    bool AddKeyToGetRequest(TRequest& request, const TLimit& limit, std::string id, TArgs&&... args) {
        return AddKeyToRequest(request, limit, std::move(id), 0, std::forward<TArgs>(args)...);
    }

    template <typename... TArgs>
    bool AddKeyToIncreaseRequest(TRequest& request, const TLimit& limit, std::string id, ui64 value, TArgs&&... args) {
        return AddKeyToRequest(request, limit, std::move(id), value, std::forward<TArgs>(args)...);
    }

private:
    template <typename... TArgs>
    bool AddKeyToRequest(TRequest& request, const TLimit& limit, std::string id, ui64 value, TArgs&&... args) {
        return AddKeyToRequestImpl(request, limit, std::move(id), value, {std::forward<TArgs>(args)...});
    }

    bool AddKeyToRequestImpl(TRequest& request, const TLimit& limit, std::string id, ui64 value, TKey key);

private:
    std::unique_ptr<TClientHelperImpl> Impl;
};

} // namespace NYmodRateSrv
