#pragma once

#include <boost/asio/ip/address.hpp>

#include <memory>
#include <string>
#include <variant>
#include <vector>

namespace NYmodRateSrv {

enum class EKeyPartType {
    String,
    Regex,
    Ip
};

using TKeyPart = std::variant<std::string, boost::asio::ip::address>;
using TKey = std::vector<TKeyPart>;
using TLimitType = std::vector<EKeyPartType>;

class IRuleNode;
using TRuleNodePtr = std::unique_ptr<IRuleNode>;

TLimitType GetLimitTypeFromString(const std::string& strType);

bool IsIncluded(const std::string& lhs, const std::string& rhs, EKeyPartType type);

TRuleNodePtr MakeRuleNodeByType(EKeyPartType type);

std::string MakeKeyForType(const TKeyPart& part, EKeyPartType type);

} // namespace NYmodRateSrv
