#include "config_reader.h"

#include <fstream>

namespace NYmodRateSrv {

namespace {

std::ifstream OpenFile(const std::string& filename) {
    std::ifstream stream {filename};
    if (!stream) {
        throw std::runtime_error("Fail to read configuration from file " + filename);
    }
    return stream;
}

} // namespace anonymous

TLimitConfiguration ReadLimitConfiguration(const std::string& filename) {
    std::ifstream stream = OpenFile(filename);
    return ReadLimitConfiguration(stream);
}

TLimitConfiguration ReadLimitConfiguration(std::istream& stream) {
    return ReadLimitConfiguration(YAML::Load(stream));
}

TLimitConfiguration ReadLimitConfiguration(const YAML::Node& domainsNode) {
    TLimitConfiguration configuration;
    configuration.reserve(domainsNode.size());

    for (auto it = domainsNode.begin(); it != domainsNode.end(); ++it) {
        auto domain = it->first.as<std::string>();
        auto domainNodes = it->second;
        TDomainConf domainConf;
        domainConf.reserve(domainNodes.size());

        for (const auto ruleNodes : domainNodes) {
            TRuleConf ruleConf;
            ruleConf.reserve(ruleNodes.size());

            for (const auto ruleNode : ruleNodes) {
                ruleConf.push_back(ruleNode.as<std::string>());
            }
            domainConf.push_back(std::move(ruleConf));
        }

        configuration.emplace_back(std::move(domain), std::move(domainConf));
    }

    return configuration;
}

TGroupConfiguration ReadGroupConfiguration(const std::string& filename, const std::string& groupName) {
    std::ifstream stream = OpenFile(filename);
    return ReadGroupConfiguration(stream, groupName);
}

TGroupConfiguration ReadGroupConfiguration(std::istream& stream, const std::string& groupName) {
    const auto groupsNode = YAML::Load(stream);
    return groupsNode[groupName];
}

} // namespace NYmodRateSrv
