#pragma once

#include <yaml-cpp/yaml.h>

#include <istream>
#include <string>
#include <utility>
#include <vector>

namespace NYmodRateSrv {

using TRuleConf = std::vector<std::string>;
using TDomainConf = std::vector<TRuleConf>;
using TLimitConfiguration = std::vector<std::pair<std::string, TDomainConf>>;

TLimitConfiguration ReadLimitConfiguration(const std::string& filename);
TLimitConfiguration ReadLimitConfiguration(std::istream& stream);
TLimitConfiguration ReadLimitConfiguration(const YAML::Node& domainsNode);

using TGroupConfiguration = YAML::Node;

TGroupConfiguration ReadGroupConfiguration(const std::string& filename, const std::string& groupName);
TGroupConfiguration ReadGroupConfiguration(std::istream& stream, const std::string& groupName);

} // namespace NYmodRateSrv
