#pragma once

#include "config_reader.h"
#include "common.h"

#include <memory>
#include <optional>
#include <string>
#include <vector>

namespace NYmodRateSrv {

struct TConfigNode;
using TConfigNodePtr = std::unique_ptr<TConfigNode>;

struct TConfigNode {
    explicit TConfigNode(std::string value = {});
    void Merge(TConfigNodePtr other);

    std::string Value;
    std::vector<TConfigNodePtr> Childs;
    std::optional<size_t> DomainId;
};

TConfigNodePtr UnifyConfiguration(const TLimitConfiguration& configuration, const TLimitType& limitType);

} // namespace NYmodRateSrv
