#include "ip.h"

namespace NYmodRateSrv::NKeyParts::NIp {

std::string MakeKey(const TKeyPart& part) {
    if (!std::holds_alternative<TAddress>(part)) {
        throw std::invalid_argument("Invalid key part, expected ip");
    }
    return std::get<TAddress>(part).to_string();
}

bool IsIncluded(const std::string& lhs, const std::string& rhs) {
    auto lNetwork = MakeNetworkFromString(lhs);
    auto rNetwork = MakeNetworkFromString(rhs);
    if (lNetwork.index() != rNetwork.index()) {
        return false;
    }
    if (std::holds_alternative<TNetwork4>(lNetwork)) {
        return Compare<TNetwork4>(lNetwork, rNetwork);
    }
    return Compare<TNetwork6>(lNetwork, rNetwork);
}

TNetwork MakeNetworkFromString(const std::string& str) {
    boost::system::error_code ec;
    if (auto network4 = boost::asio::ip::make_network_v4(str, ec); !ec) {
        return std::move(network4);
    }
    if (auto network6 = boost::asio::ip::make_network_v6(str, ec); !ec) {
        return std::move(network6);
    }
    throw std::invalid_argument("Fail to read network " + str);
}

} // namespace NYmodRateSrv::NKeyParts::NIp
