#include "regexp_string.h"

namespace NYmodRateSrv::NKeyParts::NRegexpString {

std::string MakeKey(const TKeyPart& part) {
    if (!std::holds_alternative<std::string>(part)) {
        throw std::invalid_argument("Invalid key part, expected string");
    }
    return std::get<std::string>(part);
}

bool IsIncluded(const std::string& lhs, const std::string& rhs) {
    return lhs == rhs;
}

void TNode::Add(const std::string& value, TChild child) {
    constexpr auto flags =
        std::regex_constants::extended |
        std::regex_constants::icase |
        std::regex_constants::optimize;

    Container.emplace_back(std::regex{value, flags}, std::move(child));
}

std::optional<size_t> TNode::Match(const TKey& key, size_t columnId) const {
    const auto& part = key.at(columnId);
    if (!std::holds_alternative<std::string>(part)) {
        throw std::invalid_argument("Invalid key part, expected string at column " + std::to_string(columnId));
    }
    const auto& str = std::get<std::string>(part);
    for (const auto& [regex, child] : Container) {
        if (std::regex_match(str, regex)) {
            if (auto domainId = std::get_if<size_t>(&child); domainId) {
                return *domainId;
            }
            if (auto res = std::get<TRuleNodePtr>(child)->Match(key, columnId + 1); res) {
                return res;
            }
        }
    }
    return {};
}

} // namespace NYmodRateSrv::NKeyParts::NRegexpString
