#pragma once

#include <mail/ymod_ratesrv/helper/src/rule_node.h>

#include <regex>
#include <string>
#include <vector>

/**
  * Key part for select domain by match input string by extended UNIX regular expressions
 */

namespace NYmodRateSrv::NKeyParts::NRegexpString {

std::string MakeKey(const TKeyPart& part);

bool IsIncluded(const std::string& lhs, const std::string& rhs);

class TNode : public IRuleNode {
public:
    void Add(const std::string& value, TChild child) override;
    std::optional<size_t> Match(const TKey& key, size_t columnId) const override;

private:
    std::vector<std::pair<std::regex, TChild>> Container;
};

} // namespace NYmodRateSrv::NKeyParts::NRegexpString
