#include "simple_string.h"

namespace NYmodRateSrv::NKeyParts::NSimpleString {

std::string MakeKey(const TKeyPart& part) {
    if (!std::holds_alternative<std::string>(part)) {
        throw std::invalid_argument("Invalid key part, expected string");
    }
    return std::get<std::string>(part);
}

bool IsIncluded(const std::string& lhs, const std::string& rhs) {
    return lhs == rhs;
}

void TNode::Add(const std::string& value, TChild child) {
    Container.emplace(value, std::move(child));
}

std::optional<size_t> TNode::Match(const TKey& key, size_t columnId) const {
    const auto& part = key.at(columnId);
    if (!std::holds_alternative<std::string>(part)) {
        throw std::invalid_argument("Invalid key part, expected string at column " + std::to_string(columnId));
    }
    const auto& str = std::get<std::string>(part);
    if (auto res = MatchByStr(str, key, columnId); res) {
        return res;
    }
    if (str != "*") {
        return MatchByStr("*", key, columnId);
    }
    return {};
}

std::optional<size_t> TNode::MatchByStr(const std::string& str, const TKey& key, size_t columnId) const {
    auto it = Container.find(str);
    if (it == Container.end()) {
        return {};
    }
    auto& child = it->second;
    if (auto domainId = std::get_if<size_t>(&child); domainId) {
        return *domainId;
    }
    return std::get<TRuleNodePtr>(child)->Match(key, columnId + 1);
}

} // namespace NYmodRateSrv::NKeyParts::NSimpleString
