#pragma once

#include <mail/ymod_ratesrv/helper/src/rule_node.h>

#include <string>
#include <tuple>
#include <unordered_map>
#include <utility>

/**
  * Key part for select domain by exact match input string
  * Rule '*' matches any input string
 */

namespace NYmodRateSrv::NKeyParts::NSimpleString {

std::string MakeKey(const TKeyPart& part);

bool IsIncluded(const std::string& lhs, const std::string& rhs);

class TNode : public IRuleNode {
public:
    void Add(const std::string& value, TChild child) override;
    std::optional<size_t> Match(const TKey& key, size_t columnId) const override;

private:
    std::optional<size_t> MatchByStr(const std::string& str, const TKey& key, size_t columnId) const;

private:
    std::unordered_map<std::string, TChild> Container;
};

} // namespace NYmodRateSrv::NKeyParts::NSimpleString
