#pragma once

#include "rule_node.h"
#include "config_unifier.h"
#include "config_reader.h"
#include "common.h"

#include <mail/ymod_ratesrv/src/request.h>

#include <memory>
#include <string>

namespace NYmodRateSrv {

class TLimit {
public:
    TLimit(
        bool enabled,
        bool dryRun,
        TLimitType type,
        std::string groupName,
        std::string limitName,
        TLimitConfiguration configuration
    );

    bool IsEnabled() const;
    bool IsDryRun() const;
    const TLimitType& GetType() const;

    std::string GetGroupName() const;
    std::string GetLimitName() const;

    TRequestPart MakeRequestPart(ui64 value, TKey key) const;

private:
    void Init(TLimitConfiguration configuration);
    TRuleNodePtr MakeRuleTree(const TConfigNode& confNode, size_t level);

private:
    bool Enabled;
    bool DryRun;
    TLimitType Type;
    std::string GroupName;
    std::string LimitName;
    TRuleNodePtr Rules;
    std::vector<std::string> Domains;
};

using TLimitPtr = std::shared_ptr<TLimit>;

} // namespace NYmodRateSrv
