#pragma once

#include "common.h"

#include <memory>
#include <optional>
#include <variant>

namespace NYmodRateSrv {

class IRuleNode {
public:
    using TChild = std::variant<TRuleNodePtr, size_t>;

    virtual ~IRuleNode() = default;

    virtual void Add(const std::string& value, TChild child) = 0;
    virtual std::optional<size_t> Match(const TKey& key, size_t columnId) const = 0;
};

} // namespace NYmodRateSrv
