#pragma once

#include "request.h"
#include "response.h"

#include <yplatform/task_context.h>

#include <boost/system/error_code.hpp>

#include <functional>

namespace NYmodRateSrv {

class IClient {
public:
    using TTaskContextPtr = yplatform::task_context_ptr;
    using TCallback = std::function<void(boost::system::error_code ec, TResponse response)>;

    virtual ~IClient() = default;

    virtual void SendGetRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) = 0;
    virtual void SendIncreaseRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) = 0;
};

} // namespace NYmodRateSrv
