#include "module.h"
#include "module_impl.h"

#include <yplatform/module_registration.h>

namespace NYmodRateSrv {

TModule::TModule(yplatform::reactor& reactor)
    : Impl(std::make_unique<TModuleImpl>(reactor))
{}

void TModule::init(const yplatform::ptree& configuration) {
    Impl->logger(logger());
    Impl->Init(configuration);
}

void TModule::SendGetRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) {
    Impl->SendGetRequest(std::move(ctx), request, std::move(callback));
}

void TModule::SendIncreaseRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) {
    Impl->SendIncreaseRequest(std::move(ctx), request, std::move(callback));
}

} // namespace NYmodRateSrv

REGISTER_MODULE(NYmodRateSrv::TModule)
