#pragma once

#include "client.h"

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <yplatform/ptree.h>

#include <memory>

namespace NYmodRateSrv {

class TModuleImpl;

class TModule : public IClient, public yplatform::module {
public:
    explicit TModule(yplatform::reactor& reactor);

    void init(const yplatform::ptree& configuration);

    void SendGetRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) override;
    void SendIncreaseRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) override;

private:
    std::unique_ptr<TModuleImpl> Impl;
};

} // namespace NYmodRateSrv
