#pragma once

#include "worker.h"
#include "client.h"

#include <ymod_httpclient/cluster_client.h>

#include <yplatform/task_context.h>
#include <yplatform/reactor.h>
#include <yplatform/coroutine.h>
#include <yplatform/log.h>
#include <yplatform/ptree.h>

#include <memory>

namespace NYmodRateSrv {

class TModuleImpl : public yplatform::log::contains_logger {
public:
    using TTaskContextPtr = IClient::TTaskContextPtr;
    using TCallback = IClient::TCallback;

    explicit TModuleImpl(yplatform::reactor& reactor);

    void Init(const yplatform::ptree& configuration);

    void SendGetRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback);
    void SendIncreaseRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback);

private:
    void CreateWorker(TTaskContextPtr ctx, TWorker::EMode mode ,const TRequest& request, TCallback callback);

private:
    yplatform::reactor& Reactor;
    std::shared_ptr<ymod_httpclient::cluster_call> HttpClient;
};

TModuleImpl::TModuleImpl(yplatform::reactor& reactor)
    : Reactor(reactor)
{}

void TModuleImpl::Init(const yplatform::ptree& configuration) {
    HttpClient = std::make_shared<yhttp::cluster_client>(Reactor, configuration.get_child("http_client"));
}

void TModuleImpl::SendGetRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) {
    CreateWorker(std::move(ctx), TWorker::EMode::Get, request, std::move(callback));
}

void TModuleImpl::SendIncreaseRequest(TTaskContextPtr ctx, const TRequest& request, TCallback callback) {
    CreateWorker(std::move(ctx), TWorker::EMode::Increase, request, std::move(callback));
}

void TModuleImpl::CreateWorker(TTaskContextPtr ctx, TWorker::EMode mode ,const TRequest& request, TCallback callback) {
    auto worker = std::make_shared<TWorker>(HttpClient, std::move(ctx), mode, request, std::move(callback));
    yplatform::spawn(worker);
}

} // namespace NYmodRateSrv
