#pragma once

#include <util/system/types.h>

#include <string>
#include <unordered_map>

namespace NYmodRateSrv {

struct TRequestPart {
    TRequestPart(
        std::string group,
        std::string limit,
        std::string key,
        ui64 value,
        std::string domain = {});

    TRequestPart(
        std::string group,
        std::string limit,
        std::string key,
        std::string domain = {});

    std::string Group;
    std::string Limit;
    std::string Key;
    std::string Domain;
    ui64 Value;
};

class TRequest {
public:
    bool Add(std::string id, TRequestPart part);
    std::string Add(TRequestPart part);

    size_t Size() const;
    void Clear();
    bool HasPartWithDomain(const std::string& domain) const;

    std::string MakeGetRequest() const;
    std::string MakeIncreaseRequest() const;

private:
    std::unordered_map<std::string, TRequestPart> Request;
};

} // namespace NYmodRateSrv
