#include "response.h"

#include <library/cpp/json/json_reader.h>

namespace NYmodRateSrv {

TResponse MakeResponseFromJson(const std::string& json) {
    TResponse response;
    NJson::TJsonValue jsonValue;
    ReadJsonTree(json, &jsonValue, true);

    const auto& counters = jsonValue["counters"].GetMap();
    for (const auto& [id, counterValue] : counters) {
        TCounter counter;
        const auto& counterMap = counterValue.GetMap();
        const auto& status = counterMap.at("status").GetString();

        if (status == "ok") {
            counter.State = ECounterState::Ok;
        } else if (status == "error") {
            counter.State = ECounterState::Error;
        } else if (status == "exceeded") {
            counter.State = ECounterState::Exceeded;
        }

        if (counter.State == ECounterState::Ok || counter.State == ECounterState::Exceeded) {
            counter.Current = counterMap.at("current").GetUInteger();
            counter.Available = counterMap.at("available").GetInteger();
        } else if (counter.State == ECounterState::Error) {
            counter.Description = static_cast<std::string>(counterMap.at("description").GetString());
        }

        response.emplace(static_cast<std::string>(id), std::move(counter));
    }

    return response;
}

} // namespace NYmodRateSrv
