#pragma once

#include <util/system/types.h>

#include <string>
#include <unordered_map>

namespace NYmodRateSrv {

enum class ECounterState {
    Ok,
    Exceeded,
    Error,
    Unknown
};

struct TCounter {
    ECounterState State = ECounterState::Unknown;
    ui64 Current = 0;
    i64 Available = 0;
    std::string Description;

    bool operator==(const TCounter& other) const {
        return
            State == other.State &&
            Current == other.Current &&
            Available == other.Available &&
            Description == other.Description;
    }
};

using TResponse = std::unordered_map<std::string, TCounter>;

TResponse MakeResponseFromJson(const std::string& json);

} // namespace NYmodRateSrv
