#include "util.h"

namespace NYmodRateSrv {

void CheckCounter(
    const std::string& id,
    const std::string& group,
    const std::string& limit,
    const std::string& key,
    const std::string& domain)
{
    if (id.empty()) {
        throw std::invalid_argument("Id must not be empty");
    }

    if (group.empty()) {
        throw std::invalid_argument("Group must not be empty");
    }
    if (group.find(':') != std::string::npos) {
        throw std::invalid_argument("Group must not сontain ':'");
    }

    if (limit.empty()) {
        throw std::invalid_argument("Limit must not be empty");
    }
    if (limit.find(':') != std::string::npos) {
        throw std::invalid_argument("Limit must not сontain ':'");
    }
    if (limit.find('@') != std::string::npos) {
        throw std::invalid_argument("Limit must not сontain '@'");
    }

    if (key.empty()) {
        throw std::invalid_argument("Key must not be empty");
    }

    if (domain.find(':') != std::string::npos) {
        throw std::invalid_argument("Domain must not сontain ':'");
    }
}

std::string MakeCounter(
    const std::string& group,
    const std::string& limit,
    const std::string& key,
    const std::string& domain)
{
    std::string res = group + ':' + limit;
    if (!domain.empty()) {
        res += '@' + domain;
    }
    res += ':' + key;

    return res;
}

} // namespace NYmodRateSrv
