#pragma once

#include "client.h"
#include "request.h"
#include "response.h"

#include <ymod_httpclient/call.h>

#include <yplatform/coroutine.h>
#include <yplatform/log.h>
#include <yplatform/time_traits.h>

#include <memory>

namespace NYmodRateSrv {

class TWorker : public yplatform::log::contains_logger {
public:
    using TYieldCtx = yplatform::yield_context<TWorker>;
    using THttpClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;
    using TTaskContextPtr = IClient::TTaskContextPtr;
    using TCallback = IClient::TCallback;

    enum class EMode {
        Get,
        Increase
    };

    TWorker(
        THttpClientPtr httpClient,
        TTaskContextPtr ctx,
        EMode mode,
        const TRequest& request,
        TCallback callback);

    void operator()(
        TYieldCtx yieldCtx,
        boost::system::error_code ec = {},
        yhttp::response response = {});

private:
    std::pair<boost::system::error_code, TResponse> ParseHttpResponse(const yhttp::response& response);
    void WriteLog(const boost::system::error_code& ec);

private:
    THttpClientPtr HttpClient;
    TTaskContextPtr Ctx;
    EMode Mode;
    std::string Request;
    size_t Size;
    TCallback Callback;

    yplatform::time_traits::time_point StartedAt;
};

} // namespace NYmodRateSrv
