#include "print_counter.h"
#include <mail/ymod_ratesrv/src/response.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

using namespace testing;
using namespace NYmodRateSrv;

TEST(TTestResponse, Empty) {
    EXPECT_THAT(MakeResponseFromJson("{\"counters\": {}}"), SizeIs(0));
}

TEST(TTestResponse, Mixed) {
    const auto json = R"({"counters": {
        "id1": {"status": "ok", "current": 100, "available": 200},
        "id2": {"status": "exceeded", "current": 200, "available": -100},
        "id3": {"status": "error", "description": "error description"}
    }})";

    auto response = MakeResponseFromJson(json);

    EXPECT_THAT(response, SizeIs(3));
    EXPECT_EQ(response["id1"], (TCounter{ECounterState::Ok, 100, 200, ""}));
    EXPECT_EQ(response["id2"], (TCounter{ECounterState::Exceeded, 200, -100, ""}));
    EXPECT_EQ(response["id3"], (TCounter{ECounterState::Error, 0, 0, "error description"}));
}

TEST(TTestResponse, Invalid) {
    const auto json1 = R"({"counters": {
        "id1": {"current": 100, "available": 200}
    }})";
    EXPECT_THROW(MakeResponseFromJson(json1), std::exception);

    const auto json2 = R"({"counters": {
        "id1": {"status": "ok", "available": 200}
    }})";
    EXPECT_THROW(MakeResponseFromJson(json2), std::exception);

    const auto json3 = R"({"counters": {
        "id1": {"status": "ok", "current": 100}
    }})";
    EXPECT_THROW(MakeResponseFromJson(json3), std::exception);

    const auto json4 = R"({"counters": {
        "id1": {"status": "error", "current": 100, "available": 200}
    }})";
    EXPECT_THROW(MakeResponseFromJson(json4), std::exception);
}
