#include <mail/ymod_ratesrv/src/util.h>

#include <gtest/gtest.h>
#include <gmock/gmock.h>

using namespace testing;
using namespace NYmodRateSrv;

TEST(TTestUtil, CheckCounter) {
    EXPECT_NO_THROW(CheckCounter("id", "group", "limit", "key", ""));
    EXPECT_NO_THROW(CheckCounter("id", "group", "limit", "key", "domain"));
    EXPECT_NO_THROW(CheckCounter("id", "group", "limit", "key:subkey@ololo", "domain"));

    EXPECT_THROW(CheckCounter("", "group", "limit", "key", "domain"), std::invalid_argument);

    EXPECT_THROW(CheckCounter("id", "", "limit", "key", "domain"), std::invalid_argument);
    EXPECT_THROW(CheckCounter("id", "group:limit", "limit", "key", "domain"), std::invalid_argument);

    EXPECT_THROW(CheckCounter("id", "group", "", "key", "domain"), std::invalid_argument);
    EXPECT_THROW(CheckCounter("id", "group", "limit:key", "key", "domain"), std::invalid_argument);
    EXPECT_THROW(CheckCounter("id", "group", "limit@domain", "key", "domain"), std::invalid_argument);

    EXPECT_THROW(CheckCounter("id", "group", "limit", "", "domain"), std::invalid_argument);
    EXPECT_THROW(CheckCounter("id", "group", "limit", "key", "domain:key"), std::invalid_argument);
}

TEST(TTestUtil, MakeCounter) {
    EXPECT_EQ(MakeCounter("group", "limit", "key", ""), "group:limit:key");
    EXPECT_EQ(MakeCounter("group", "limit", "key", "domain"), "group:limit@domain:key");
}
