#pragma once

#include <string>

namespace ymod_smtpclient {

namespace sasl {
enum class Mechanism : std::uint8_t {
    None = 0,
    Login,
    Plain,
    Xoauth2
};
}   // namespace sasl

std::string to_string(sasl::Mechanism mechanism);

namespace detail {

struct AuthData {
    std::string login;
    std::string password;
    std::string token;
    sasl::Mechanism mechanism = sasl::Mechanism::None;
};

}   // namespace detail

struct AuthData: public detail::AuthData {
    static AuthData LOGIN(std::string login, std::string password);
    static AuthData PLAIN(std::string login, std::string password);
    static AuthData XOAUTH2(std::string user, std::string token);
    // try LOGIN then PLAIN
    static AuthData BEST(std::string login, std::string password);
};

}   // namespace ymod_smtpclient
