#pragma once

#include <ymod_smtpclient/errors.h>
#include <ymod_smtpclient/response.h>
#include <ymod_smtpclient/request.h>
#include <ymod_smtpclient/settings.h>
#include <ymod_smtpclient/smtp_session.h>

#include <yplatform/task_context.h>

namespace ymod_smtpclient {

class Call {
public:
    using Context = yplatform::task_context_ptr;
    using Callback = std::function<void (::ymod_smtpclient::error::Code, Response)>;

    virtual void asyncRun(Context ctx, Request request, Callback callback) = 0;
    virtual void asyncRun(Context ctx, Request request, Options opts, Callback callback) = 0;
    virtual SmtpSessionPtr createSmtpSession(Context ctx) = 0;
    virtual SmtpSessionPtr createSmtpSession(Context ctx, const Timeouts& timeouts) = 0;

    virtual ~Call() {}
};

}   // namespace ymod_smtpclient
