#pragma once

#include <ymod_smtpclient/call.h>
#include <ymod_smtpclient/smtp_session.h>

#include <yplatform/net/io_data.h>

namespace ymod_smtpclient {

class Client
    : public yplatform::log::contains_logger
    , public boost::noncopyable
{
public:
    using Context = Call::Context;
    using Callback = Call::Callback;
    class Impl;

    Client(
        boost::asio::io_service& ios,
        const yplatform::log::source& logger,
        const Settings& settings
    );

    void asyncRun(Context ctx, Request request, Callback callback);
    void asyncRun(Context ctx, Request request, Options opts, Callback callback);
    SmtpSessionPtr createSmtpSession(Context ctx);
    SmtpSessionPtr createSmtpSession(Context ctx, const Timeouts& timeouts);

private:
    std::shared_ptr<Impl> impl;
};

}   // namespace ymod_smtpclient
