#pragma once

#include <ymod_smtpclient/smtp_point.h>

#include <yplatform/time_traits.h>
#include <yplatform/net/settings.h>
#include <yplatform/net/ssl_settings.h>
#include <yplatform/net/dns/resolver_settings.h>

namespace ymod_smtpclient {

struct Settings {
    using duration = yplatform::time_traits::duration;

    bool enableLogging = false;
    bool logProtocol = false;
    bool reuseConnection = false;
    uint16_t maxPoolSize = 10;  // per io_service
    duration sessionMaxIdleTime = yplatform::time_traits::minutes(1);

    duration connectAttemptTimeout = yplatform::time_traits::seconds(3);
    // default timeouts
    duration connectTimeout = yplatform::time_traits::seconds(5);
    duration commandTimeout = yplatform::time_traits::seconds(10);
    duration dataTimeout = yplatform::time_traits::seconds(30);

    bool allowErrorsOnRcptTo = true;
    bool dotStuffing = true;
    std::size_t maxAuthLineLength = 1024;
    unsigned short smtpSslDefaultPort = SMTP_SSL_DEFAULT_PORT;

    yplatform::net::client_settings socket;
    yplatform::net::ssl_settings ssl;
    yplatform::net::dns::resolver_service_settings dns;

    void init(const yplatform::ptree& conf) {
        enableLogging = conf.get("enable_logging", enableLogging);
        logProtocol = conf.get("enable_log_protocol", logProtocol);
        connectAttemptTimeout = conf.get("connect_attempt_timeout", connectAttemptTimeout);
        reuseConnection = conf.get("reuse_connection", reuseConnection);
        maxPoolSize = conf.get("max_pool_size", maxPoolSize);
        sessionMaxIdleTime = conf.get("max_idle_time", sessionMaxIdleTime);

        auto timeoutsOptional = conf.get_child_optional("default_timeouts");
        if (timeoutsOptional) {
            connectTimeout = timeoutsOptional->get("connect", connectTimeout);
            commandTimeout = timeoutsOptional->get("command", commandTimeout);
            dataTimeout = timeoutsOptional->get("data", dataTimeout);
        }

        allowErrorsOnRcptTo = conf.get("allow_errors_on_rcpt_to_command", allowErrorsOnRcptTo);
        dotStuffing = conf.get("dot_stuffing", dotStuffing);
        maxAuthLineLength = conf.get("max_auth_line_length", maxAuthLineLength);
        smtpSslDefaultPort = conf.get("smtp_ssl_default_port", smtpSslDefaultPort);

        socket.parse_ptree(conf.get_child("socket", yplatform::ptree()));
        ssl.parse_ptree(conf.get_child("ssl", yplatform::ptree()));
        dns.parse(conf.get_child("dns", yplatform::ptree()));
    }
};

}   // namespace ymod_smtpclient
