#pragma once

#include <string>
#include <tuple>

namespace ymod_smtpclient {

constexpr unsigned short SMTP_DEFAULT_PORT = 25;
constexpr unsigned short SMTP_SSL_DEFAULT_PORT = 465;

struct SmtpPoint {
    enum Proto { smtp, lmtp };

    Proto proto = smtp;
    std::string host;
    unsigned short port = SMTP_DEFAULT_PORT;

    static SmtpPoint fromString(const std::string& info);
};

inline bool operator==(const SmtpPoint& lhs, const SmtpPoint& rhs) {
    return std::tie(lhs.proto, lhs.host, lhs.port) == std::tie(rhs.proto, rhs.host, rhs.port);
}

inline std::string to_string(SmtpPoint::Proto proto) {
    switch(proto) {
    case SmtpPoint::smtp:
        return "smtp";
    case SmtpPoint::lmtp:
        return "lmtp";
    default:
        throw std::logic_error("Unknown smtp protocol: " + std::to_string(int(proto)));
    }
}

inline std::string to_string(const SmtpPoint& point) {
    return to_string(point.proto) + "://" + point.host + ":" + std::to_string(point.port);
}

}   // namespace ymod_smtpclient
