#pragma once

#include <ymod_smtpclient/errors.h>
#include <ymod_smtpclient/request.h>
#include <ymod_smtpclient/response.h>
#include <ymod_smtpclient/settings.h>
#include <ymod_smtpclient/server_extensions.h>

#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>

namespace ymod_smtpclient {

class SmtpSession {
public:
    using Response = MultiLineResponse;
    using Handler = std::function<void(error::Code)>;
    using SmtpHandler = std::function<void(error::Code, Response)>;
    using ContextPtr = yplatform::task_context_ptr;
    using Duration = yplatform::time_traits::duration;
    using TimePoint = yplatform::time_traits::time_point;

    virtual ~SmtpSession() = default;

    virtual void cancel() = 0;

    virtual void close() = 0;

    virtual void shutdown(bool gracefull=true) = 0;

    virtual bool isOpen() const = 0;

    virtual bool isEncrypted() const = 0;

    virtual ServerExtensions getServerExtensions() const = 0;

    virtual void asyncConnect(std::string host, uint16_t port, Optional<bool> useSsl, Handler handler) = 0;

    virtual void asyncGreeting(SmtpHandler handler) = 0;

    virtual void asyncHelo(SmtpPoint::Proto proto, SmtpHandler handler) = 0;

    virtual void asyncHelo(SmtpPoint::Proto proto, const std::string& hostname, SmtpHandler handler) = 0;

    virtual void asyncAuth(const AuthData& authData, SmtpHandler handler) = 0;

    virtual void asyncStartTls(SmtpHandler handler) = 0;

    virtual void asyncMailFrom(const MailFrom& mailFrom, SmtpHandler handler) = 0;

    virtual void asyncRcptTo(const RcptTo& rcptTo, bool enableDsn, SmtpHandler handler) = 0;

    virtual void asyncDataStart(SmtpHandler handler) = 0;

    virtual void asyncRset(SmtpHandler handler) = 0;

    virtual void asyncQuit(SmtpHandler handler) = 0;

    virtual void asyncWriteMessage(const std::string& msg, bool enableDotStuffing, SmtpHandler handler) = 0;
};

using SmtpSessionPtr = std::shared_ptr<SmtpSession>;

}  // namespace ymod_smtpclient
