#include <ymod_smtpclient/auth.h>

namespace ymod_smtpclient {

AuthData AuthData::LOGIN(std::string login, std::string password) {
    AuthData result;
    result.login = std::move(login);
    result.password = std::move(password);
    result.mechanism = sasl::Mechanism::Login;
    return result;
}

AuthData AuthData::PLAIN(std::string login, std::string password) {
    AuthData result;
    result.login = std::move(login);
    result.password = std::move(password);
    result.mechanism = sasl::Mechanism::Plain;
    return result;
}

AuthData AuthData::XOAUTH2(std::string user, std::string token) {
    AuthData result;
    result.login = std::move(user);
    result.token = std::move(token);
    result.mechanism = sasl::Mechanism::Xoauth2;
    return result;
}

AuthData AuthData::BEST(std::string login, std::string password) {
    AuthData result;
    result.login = std::move(login);
    result.password = std::move(password);
    result.mechanism = sasl::Mechanism::None;
    return result;
}

}   // namespace ymod_stmpclient

