#include "call_impl.h"

namespace ymod_smtpclient {

void CallImpl::init(const yplatform::ptree& conf) {
    Settings opts;
    opts.init(conf);
    auto reactor = yplatform::global_reactor_set->get(conf.get("reactor", "global"));
    init(reactor, opts);
}

void CallImpl::init(yplatform::reactor_ptr reactor, const Settings& opts) {
    settings = opts;

    for (size_t i = 0; i < reactor->size(); ++i) {
        if ((*reactor)[i]->size() != 1) {
            throw std::runtime_error("smtpclient is optimized for single-thread reactors");
        }
    }

    yplatformIos.reset(new yplatform::net::io_service(reactor));
    yplatformIos->init();
    yplatformIos->create_ssl_context(settings.ssl);
    yplatformIos->setup_dns(settings.dns);

    for (size_t i = 0; i < yplatformIos->size(); ++i) {
        auto& iodata = yplatformIos->operator [](i);
        pool.push_back(std::make_shared<Client>(*iodata.get_io(), logger(), settings));
    }
}

void CallImpl::asyncRun(Context ctx, Request request, Callback callback) {
    auto client = pool[poolIndx++ % pool.size()];
    client->asyncRun(std::move(ctx), std::move(request), std::move(callback));
}

void CallImpl::asyncRun(Context ctx, Request request, Options opts, Callback callback) {
    auto client = pool[poolIndx++ % pool.size()];
    client->asyncRun(ctx, std::move(request), std::move(opts), std::move(callback));
}

SmtpSessionPtr CallImpl::createSmtpSession(Context ctx, const Timeouts& timeouts) {
    auto client = pool[poolIndx++ % pool.size()];
    return client->createSmtpSession(ctx, timeouts);
}

SmtpSessionPtr CallImpl::createSmtpSession(Context ctx) {
    auto client = pool[poolIndx++ % pool.size()];
    return client->createSmtpSession(ctx);
}

}   // namespace ymod_smtpclient

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(ymod_smtpclient::CallImpl)
